<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\FeesDiscount;

class FeesDiscountController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }

        $discounts = FeesDiscount::orderBy('name')->get();
        return view('admin.fees.discount.index', compact('discounts', 'user'));
    }

    public function create()
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }
        return view('admin.fees.discount.create', compact('user'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:percentage,fixed',
            'amount' => 'required|numeric|min:0',
            'description' => 'nullable|string',
            'is_active' => 'nullable|boolean',
        ]);
        $validated['is_active'] = $request->boolean('is_active', true);

        FeesDiscount::create($validated);

        return redirect()->route('admin.fees-discount.index')->with('success', 'Fees Discount created successfully.');
    }

    public function edit(string $id)
    {
        $user = Auth::user();
        if (!$user || !$user->isAdmin()) {
            abort(403, 'Unauthorized access');
        }
        $discount = FeesDiscount::findOrFail($id);
        return view('admin.fees.discount.edit', compact('discount', 'user'));
    }

    public function update(Request $request, string $id)
    {
        $discount = FeesDiscount::findOrFail($id);
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'required|in:percentage,fixed',
            'amount' => 'required|numeric|min:0',
            'description' => 'nullable|string',
            'is_active' => 'nullable|boolean',
        ]);
        $validated['is_active'] = $request->boolean('is_active', true);

        $discount->update($validated);

        return redirect()->route('admin.fees-discount.index')->with('success', 'Fees Discount updated successfully.');
    }

    public function destroy(string $id)
    {
        $discount = FeesDiscount::findOrFail($id);
        $discount->delete();

        return redirect()->route('admin.fees-discount.index')->with('success', 'Fees Discount deleted successfully.');
    }
}


